####################
# ## PARAMETERS ## #
####################

config={
  # paths for connecting to cloud storage
  "vm_path": 'ebm-life-cycle/',
  "gs_path": 'gen-tfrc-uscentral1',

  # device type ('tpu' or 'gpu' or 'cpu')
  "device_type": 'tpu',

  'exp_dir': 'tfrc_out/attack',
  'exp_name': 'efficientnet_test',
  'data_type': 'imagenet2012',
  'split': 'validation',
  'image_dims': [224, 224, 3],

  'image_dims_clf': [600, 600, 3],
  'pixel_scale_clf': [0, 255],

  'start_batch': 1,
  'end_batch': 100,
  'batch_size': 8,
  'shuffle': True,

  'adv_steps': 50,
  'adv_eps': 2.0,
  'adv_eta': 1.0,
  'adv_rand_start': True,

  'eot_attack_reps': 16,
  'eot_defense_reps': 64,

  'langevin_steps': 200,
  'epsilon': 2e-2,
  'mcmc_temp': 1e-4,

  'ebm_weights': "gs://gen-tfrc-uscentral1/tfrc_out/imagenet/conv_biggan_21-07-07-04-42-07/checkpoints/ebm_310000.ckpt",
  'net_type': 'ebm_biggan',
  'ebm_ch_width': 48,

  'log_freq': 1,
  'record_image_states': False
}
